/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.events;

import javax.annotation.Nullable;
import lombok.NonNull;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.UserHostmask;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.types.GenericCTCPEvent;

public class TimeEvent
extends Event
implements GenericCTCPEvent {
    protected final Channel channel;
    protected final UserHostmask userHostmask;
    protected final User user;

    public TimeEvent(PircBotX bot, Channel channel, @NonNull UserHostmask userHostmask, User user) {
        super(bot);
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        this.channel = channel;
        this.userHostmask = userHostmask;
        this.user = user;
    }

    @Override
    public void respond(String response) {
        this.getUser().send().ctcpResponse(response);
    }

    public String toString() {
        return "TimeEvent(channel=" + this.getChannel() + ", userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeEvent)) {
            return false;
        }
        TimeEvent other = (TimeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TimeEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        return result;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }
}

